﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;

namespace YumeNikkiRandomizer
{
    class Variables : RPGByteData
    {
        List<Variable> variables;
        
        public Variables(FileStream f)
        {
            load(f);
        }
        public Variables()
        {
        }
        
        override public void load(FileStream f)
        {
            variables = M.readDatabaseList<Variable>(f, "Variables", "Variable", ref M.variableNames);
        }
        
        override protected void myWrite()
        {
            M.writeListNoLength<Variable>(variables);
        }
    }
    
    class Variable : RPGDatabaseEntry
    {
        int id = 0;
        string variableName = ""; // 01
        
        List<int> chunkList;
        
        public Variable(FileStream f)
        {
            load(f);
        }
        public Variable()
        {
        }
        
        public void load(FileStream f)
        {
            chunkList = new List<int>();
            
            id = M.readMultibyte(f);
            
            if (Chunks.next(f, 0x01, chunkList))
                variableName = M.readStringDataName(f, id, ref M.variableNames, M.S_UNTRANSLATED);
            
            M.byteCheck(f, 0x00);
        }
        
        public void write()
        {
            M.writeMultibyte(id);
            
            if (Chunks.wasNext(0x01, chunkList))
                M.writeString(variableName, M.S_UNTRANSLATED);
            
            M.writeByte(0x00);
        }
        
        public bool isBlank()
        {
            if (variableName != "") // 01
                return false;
            
            return true;
        }
    }
}
